/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.rotational_compressor;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.lgmrszd.compressedcreativity.blocks.rotational_compressor.RotationalCompressorTileEntity;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationalCompressorInstance
extends KineticTileInstance<RotationalCompressorTileEntity> {
    protected final RotatingData shaft;
    protected final RotatingData fan;
    final Direction direction;
    private final Direction opposite;

    public RotationalCompressorInstance(MaterialManager modelManager, RotationalCompressorTileEntity tile) {
        super(modelManager, (KineticTileEntity)tile);
        this.direction = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        this.opposite = this.direction.m_122424_();
        this.shaft = (RotatingData)this.getRotatingMaterial().getModel(AllBlockPartials.SHAFT_HALF, this.blockState, this.opposite).createInstance();
        this.fan = (RotatingData)modelManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(AllBlockPartials.ENCASED_FAN_INNER, this.blockState, this.opposite).createInstance();
        this.setup(this.shaft);
        this.setup(this.fan, this.getFanSpeed());
    }

    private float getFanSpeed() {
        float speed = ((RotationalCompressorTileEntity)this.blockEntity).getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        return speed;
    }

    public void update() {
        this.updateRotation(this.shaft);
        this.updateRotation(this.fan, this.getFanSpeed());
    }

    public void updateLight() {
        BlockPos behind = this.pos.m_142300_(this.opposite);
        this.relight(behind, new FlatLit[]{this.shaft});
        BlockPos inFront = this.pos.m_142300_(this.direction);
        this.relight(inFront, new FlatLit[]{this.fan});
    }

    public void remove() {
        this.shaft.delete();
        this.fan.delete();
    }
}

